
// NvidiaDecoder.cpp : implementation file
//

#include "stdafx.h"
#include "NvidiaDecoder.h"
#include "NvidiaDecoderDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

VOID DumpDebugMessage( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[DEBUG] ";
	
	va_list marker;

	va_start( marker, fmt);

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

DWORD WINAPI on_decode_video_framebuffer( LPVOID params )
{
	CNvidiaDecoderDlg *  pMainDialog = (CNvidiaDecoderDlg *)(params);

	BOOL bDecode = FALSE;

	ULONG nBufferLen = 0;

	ULONG nIsKeyFrame = 0;

	BOOL bKeyFrame = FALSE;

	ULONGLONG	 nSrcVideoSampleTime = 0;

	CString strLine;

	while ( TRUE && pMainDialog->m_bDecodeBuffer )
    {
		nBufferLen = 0;

		nIsKeyFrame = 0;

		if ( pMainDialog->m_pTxtFile != NULL )
		{
			if ( pMainDialog->m_pTxtFile->ReadString( strLine ) )
			{
				CStringVector strVector = pMainDialog->SplitString(strLine, ",", true);

				if ( strVector.size() >= 3 )
				{
					nBufferLen = atoi( strVector[ 0 ] );

					nSrcVideoSampleTime = _atoi64(  strVector[ 1 ] );

					nIsKeyFrame = atoi( strVector[ 2 ] );

					( nIsKeyFrame == 1 ) ? bKeyFrame = TRUE : bKeyFrame = FALSE;
				}
			}
		}

		if ( pMainDialog->m_pBinFile != NULL && nBufferLen > 0 )
		{
			pMainDialog->m_pBinFile->Read( pMainDialog->m_pH264FrameBuffer, nBufferLen );

			pMainDialog->m_nH264FrameBufferLen = nBufferLen;
			
			bDecode = AMESDK_CODEC_DECODE( pMainDialog->m_hVideoSwDecoderDev, pMainDialog->m_pH264FrameBuffer, pMainDialog->m_nH264FrameBufferLen, bKeyFrame );			

			DWORD dwMilliSeconds = ( DWORD )( 1000 / (  FPS ) );

			Sleep( dwMilliSeconds );				
		}
		else
		{
			Sleep( 1 );
		}
	}	

	return 0;
}

BOOL on_process_video_decoder_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{

	return TRUE;
}

// CNvidiaDecoderDlg dialog

CNvidiaDecoderDlg::CNvidiaDecoderDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CNvidiaDecoderDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);	
	
	m_hVideoSwDecoderDev = 0xFFFFFFFF;	

	m_hVideoDecodeThread = NULL;	

	m_hVideoDecodeThreadNumber = 0;

	m_bDecodeBuffer = FALSE;	

	m_pH264FrameBuffer  = NULL;

	m_nH264FrameBufferLen = 0;

	m_pTxtFile = NULL;

	m_pBinFile = NULL;
}

void CNvidiaDecoderDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNvidiaDecoderDlg)
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	DDX_Control(pDX, IDC_BTN_BROWSER, m_btnBrowser);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_editFilePath);
	//}}AFX_DATA_MAP		
}

BEGIN_MESSAGE_MAP(CNvidiaDecoderDlg, CDialogEx)
	//{{AFX_MSG_MAP(CNvidiaDecoderDlg)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_START, &CNvidiaDecoderDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CNvidiaDecoderDlg::OnBnClickedBtnStop)
	ON_BN_CLICKED(IDC_BTN_BROWSER, &CNvidiaDecoderDlg::OnBnClickedBtnBrowser)
END_MESSAGE_MAP()


// CNvidiaDecoderDlg message handlers

BOOL CNvidiaDecoderDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	m_pH264FrameBuffer = new BYTE[ WIDTH * HEIGHT ];

	ZeroMemory( m_pH264FrameBuffer, WIDTH * HEIGHT );
	
	CenterWindow();

	CString strCaption;

	strCaption.Format( "Yuan's Demo Software - H.264 Nvidia NvEnc Decoder" );

	SetWindowText( strCaption );

	InitializeCriticalSection( &m_hAccessFileCriticalSection );

	HwInitialize();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNvidiaDecoderDlg::OnDestroy() 
{
	OnBnClickedBtnStop();

	HwUnInitialize();

	DeleteCriticalSection( &m_hAccessFileCriticalSection );

	if ( m_pH264FrameBuffer != NULL )
	{
		delete [] m_pH264FrameBuffer;

		m_pH264FrameBuffer = NULL;
	}	

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

BOOL CNvidiaDecoderDlg::HwInitialize()
{	
	m_hVideoSwDecoderDev = AMESDK_CREATE_EX( "Common Analog Nvidia NvEnc Decoder (H.264)", 0, 6, m_statWindow.GetSafeHwnd(), &on_process_video_decoder_buffer, FALSE, TRUE, TRUE, NULL );
		
	if( m_hVideoSwDecoderDev & 0x80000000 ) 
	{ 
		m_hVideoSwDecoderDev = 0xFFFFFFFF; 

		return FALSE; 	
	}

	// SET SOFTWARE DECODER FORMAT
	//
	AMESDK_SET_STANDARD( m_hVideoSwDecoderDev, NTSC );

	AMESDK_SET_FORMAT( m_hVideoSwDecoderDev, DECODER_COLORSPACE, WIDTH, HEIGHT, DECODER_BIT_COUNT, FPS );

	AMESDK_SET_DEINTERLACE( m_hVideoSwDecoderDev, (HEIGHT > 288) ? 7 : 0 ); // DEINTERLACE

	AMESDK_RUN( m_hVideoSwDecoderDev );	

	return TRUE;
}

BOOL CNvidiaDecoderDlg::HwUnInitialize()
{
	m_bDecodeBuffer = FALSE;

	Sleep( 100 );
	
	if( m_hVideoSwDecoderDev != 0xFFFFFFFF ) 
	{
		AMESDK_DESTROY( m_hVideoSwDecoderDev );
		
		m_hVideoSwDecoderDev = 0xFFFFFFFF; 
	}		

	return TRUE;
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNvidiaDecoderDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNvidiaDecoderDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CString CNvidiaDecoderDlg::GetWorkingPath()
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	return strCurPath;
}

void CNvidiaDecoderDlg::OnBnClickedBtnStart()
{
	// TODO: Add your control notification handler code here

	m_btnStart.EnableWindow( FALSE );

	m_btnStop.EnableWindow( TRUE );

	if ( !m_strFilePath.IsEmpty() )
	{
		if ( IsFileExists( m_strFilePath ) )
		{
			m_pTxtFile = NULL;

			m_pBinFile = NULL;		

			m_pBinFile = new CStdioFile( m_strFilePath,  CFile::modeRead | CFile::typeBinary );

			CString m_strTxtFilePath = m_strFilePath;			

			m_strTxtFilePath.Replace( ".H264", ".TXT" );

			m_pTxtFile = new CStdioFile( m_strTxtFilePath,  CFile::modeRead | CFile::typeText );	

			m_bDecodeBuffer = TRUE;

			m_hVideoDecodeThread = CreateThread( NULL, 0, (LPTHREAD_START_ROUTINE)( on_decode_video_framebuffer ), (LPVOID)(this), 0, &m_hVideoDecodeThreadNumber );	
		}
	}	
}


void CNvidiaDecoderDlg::OnBnClickedBtnStop()
{
	// TODO: Add your control notification handler code here

	m_bDecodeBuffer = FALSE;

	Sleep( 100 );

	m_btnStart.EnableWindow( TRUE );

	m_btnStop.EnableWindow( FALSE );	

	if ( m_pTxtFile != NULL )
	{
		m_pTxtFile->Close();

		delete m_pTxtFile;

		m_pTxtFile = NULL;
	}

	if ( m_pBinFile != NULL )
	{
		m_pBinFile->Close();

		delete m_pBinFile;

		m_pBinFile = NULL;
	}	
}

BOOL CNvidiaDecoderDlg::IsFileExists( const TCHAR* pFile )
{
	WIN32_FIND_DATA FindFileData;

	HANDLE hFind;

	hFind = FindFirstFile(pFile, &FindFileData);

	if (hFind == INVALID_HANDLE_VALUE) 
	{
		return FALSE;
	} 
	else 
	{
		FindClose(hFind);

		return TRUE;
	}
}

void CNvidiaDecoderDlg::OnBnClickedBtnBrowser()
{
	// TODO: Add your control notification handler code here

	// SELECT THE H264 FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "H264\0*.H264\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) 
	{
		m_strFilePath = psz;

		m_editFilePath.SetWindowText( m_strFilePath );
	}
}

CStringVector CNvidiaDecoderDlg::SplitString(const CString& strSource, const CString& delim, bool bRemoveNone)
{
	CStringVector strRows;

	int nStart = 0;

	int delimLen = delim.GetLength();

	int nPos = strSource.Find(delim, nStart);

	while(nPos >= 0)
	{	
		if(bRemoveNone) 
		{
			if(nPos > nStart)
			{
				strRows.push_back(strSource.Mid(nStart, nPos - nStart));	
			}
		}
		else 
		{
			strRows.push_back(strSource.Mid(nStart, nPos - nStart));		
		}

		nStart = nPos + delimLen;

		nPos = strSource.Find(delim, nStart);	
	}	
	
	int length = strSource.GetLength();

	if(bRemoveNone)
	{
		if(length > nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	} 
	else
	{
		if(length >= nStart)
		{
			strRows.push_back(strSource.Mid(nStart, length - nStart));
		}
	}

	return strRows;
}